package bomberman.android.bomberman.android;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BClient extends Network
{
    BluetoothSocket socket;         // Gniazdo BT

    public BClient() {  }

    /**
     * Metoda służąca do łączenia się z potencjalnym serwerem
     * @param bd    Serwer
     * @return      FALSE - nie udało się połączyć, TRUE - połączenie nawiązane
     */
    public boolean Connect(BluetoothDevice bd)
    {
        try
        {
            socket = bd.createRfcommSocketToServiceRecord(uuid);
            socket.connect();
        }
        catch(Exception ex)
        {
            return false;
        }

        return true;
    }

    /**
     * Metoda służąca do zwolnienia zasobów gniazda
     */
    @Override
    public void Dispose()
    {
        try
        {
            try
            {
                socket.getInputStream().close();
            }
            catch(Throwable t) { }

            try
            {
                socket.getOutputStream().close();
            }
            catch(Throwable t) { }

            try
            {
                socket.close();
            }
            catch(Throwable t) { }

            socket = null;
        }
        catch(Throwable t)
        {
            return;
        }
    }

    /**
     * Zwraca strumień wejściowy
     * @return  Strumień gniazda
     * @throws IOException
     */
    @Override
    public InputStream GetInputStream() throws IOException
    {
        return socket.getInputStream();
    }

    /**
     * Zwraca strumień wyjściowy
     * @return  Strumień gniazda
     * @throws IOException
     */
    @Override
    public OutputStream GetOutputStream() throws IOException
    {
        return socket.getOutputStream();
    }
}
