package bomberman.android.bomberman.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.widget.Toast;

import com.badlogic.gdx.backends.android.AndroidApplication;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;

import java.util.ArrayList;
import java.util.List;

import bomberman.android.bomberman.DeviceWrapper;
import bomberman.android.bomberman.Main;

public class AndroidLauncher extends AndroidApplication 
{
    public static AndroidLauncher instance;

    public Network socket;                                      // Obiekt odpowiadający za komunikację BT
    public AndroidInterface anInterface;                        // Interfejs umożliwiający korzystanie z API Androida po stronie kodu obsługującego renderowanie
    public BluetoothAdapter ba;                                 // Adapter BT
    public List<DeviceWrapper> availableDevices;                // Lista wrapperów dostępnych urządzeń
    List<BluetoothDevice> discoveredDevices;                    // Lista urządzeń

    final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        public void onReceive(Context context, Intent intent) {  // Obiekt odpowiadający za odkrywanie urządzeń
            String action = intent.getAction();

            if (BluetoothDevice.ACTION_FOUND.equals(action))
            {
                BluetoothDevice device = intent.getParcelableExtra(BluetoothDevice.EXTRA_DEVICE);

                availableDevices.add(new DeviceWrapper(device.getName(), device.getAddress()));
                discoveredDevices.add(device);
                return;
            }
        }
    };

    public AndroidLauncher()
    {
        this.instance = this;
        anInterface = new AndroidInterface();

        ba = BluetoothAdapter.getDefaultAdapter();

        // Jeśli urządzenie nie posiada BT, zamyka aplikację
        if(ba == null) { Toast.makeText(this.getApplicationContext(), "To urządzenie nie posiada modułu Bluetooth!", Toast.LENGTH_SHORT).show(); System.exit(0); }

        // Jeśli BT nie jest włączone, włącz je
        if(!ba.isEnabled())
        {
            ba.enable();
        }

        availableDevices = new ArrayList<DeviceWrapper>();
        discoveredDevices = new ArrayList<BluetoothDevice>();
    }

	@Override
	protected void onCreate (Bundle savedInstanceState)
    {
		super.onCreate(savedInstanceState);
		AndroidApplicationConfiguration config = new AndroidApplicationConfiguration();
		initialize(new Main(anInterface), config);

        IntentFilter filter = new IntentFilter(BluetoothDevice.ACTION_FOUND);
        registerReceiver(mReceiver, filter);
	}

    @Override
    protected void onDestroy() // Wyrejestrowuje odbiornik
    {
        super.onDestroy();
        unregisterReceiver(mReceiver);
    }
}
