package bomberman.android.bomberman.android;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import bomberman.android.bomberman.CPInterface;
import bomberman.android.bomberman.DeviceWrapper;

public class AndroidInterface implements CPInterface
{
    Handler handler;

    public AndroidInterface()
    {
       handler = new Handler();
    }

    /**
     * Zwraca listę dost. urządzeń w postaci listy wrapperów
     * @return  Lista wrapperów
     */
    @Override
    public List<DeviceWrapper> GetDeviceList()
    {
       return AndroidLauncher.instance.availableDevices;
    }

    /**
     * Czyści listę urządzeń
     */
    @Override
    public void ClearDeviceList()
    {
        AndroidLauncher.instance.availableDevices.clear(); AndroidLauncher.instance.discoveredDevices.clear();
    }

    /**
     * Włącza/wyłącza szukanie urządzeń
     * @param state FALSE - wyłącza, TRUE - włącza
     */
    @Override
    public void SetDiscovery(boolean state)
    {
        if(state)
        {
            AndroidLauncher.instance.ba.startDiscovery();
        }
        else
        {
            AndroidLauncher.instance.ba.cancelDiscovery();
        }
    }

    /**
     * Resetuje połączenie z innym urządzeniem BT
     */
    @Override
    public void ResetConnection()
    {
        try
        {
            AndroidLauncher.instance.socket.Dispose();
            AndroidLauncher.instance.socket = null;
        }
        catch(Throwable t)
        {

        }
    }

    /**
     * Ustawia typ połączenia
     * @param type  FALSE - Klient, TRUE - Serwer
     */
    @Override
    public void SetConnectionType(boolean type)
    {
        this.ResetConnection();

        if(type)
        {
            AndroidLauncher.instance.socket = new BServer();
        }
        else
        {
            AndroidLauncher.instance.socket = new BClient();
        }
    }

    /**
     * Zwraca strumień wejściowy
     * @return  Strumień gniazda
     */
    @Override
    public InputStream GetInputStream()
    {
        try
        {
            return AndroidLauncher.instance.socket.GetInputStream();
        }
        catch(Throwable t)
        {
            return null;
        }
    }

    /**
     * Zwraca strumień wyjściowy
     * @return  Strumień gniazda
     */
    @Override
    public OutputStream GetOutputStream()
    {
        try
        {
            return AndroidLauncher.instance.socket.GetOutputStream();
        }
        catch(Throwable t)
        {
            return null;
        }
    }

    /**
     * Łączy z urządzeniem o podanym adresie, szukając jego odpowiednika w liście urządzeń
     * @param address   Adres urządzenia
     * @return          FALSE - nieudana prób, TRUE - połączenie nawiązane
     */
    @Override
    public boolean ConnectWith(String address)
    {
        try
        {
            for (BluetoothDevice bd : AndroidLauncher.instance.discoveredDevices)
            {
                String ad = bd.getAddress();

                if (bd.getAddress().equals(address))
                {
                    ((BClient) AndroidLauncher.instance.socket).Connect(bd);
                    break;
                }
            }
        }
        catch(Exception ex)
        {
            return false;
        }

        return true;
    }
}
