function reqChange(formId, formValues, url, respFunc) {

	$.each($(formId).serializeArray(), function(i, f) {

		formValues[f.name] = f.value;
	});

	reqChange_(formValues, url, respFunc);
}

function reqChange_(formValues, url, respFunc) {
	$.ajax({
		type : "POST",
		url : url,
		data : formValues,
		success : function(response) {
			respFunc(response);
		},
		async : true
	});
}

function getData(formValues, url, respFunc) {
	$.ajax({
		type : "GET",
		url : url,
		data : formValues,
		success : function(response) {
			respFunc(response);
		},
		async : true
	});
}

function getFrag(dt, url, respFunc) {
	$.ajax({
		type : "POST",
		url : url,
		data : JSON.stringify(dt),
		contentType : "application/json",
		success : function(response) {
			respFunc(response);
		},
		async : true
	});
}

function search() {
	var fields = {};

	$('.searchCB').each(function() {
		if (this.checked) {
			fields[$(this).val()] = $("#" + $(this).val() + "TB").val();

		}
	});

	getData(fields, "/rest/items", function(response) {
		getFrag(response, "/controlss/itemBrowser", function(resp) {
			$("#itemBrowser").html(resp);
		});
	});

}