function getId(el) {
	return el.getAttribute('data-id');
}

function appendFragment(fragID, frag, attrs, dt) {
	$.ajax({
		type : "POST",
		url : "/frag",
		data : {
			'frag' : frag,
			'attrs' : JSON.stringify(attrs),
			'dt' : JSON.stringify(dt)
		},
		dataType : "html",
		success : function(resp) {
			$('#' + fragID).html(resp);
			
		}
	});
}

function pageBar_prevPage(pageBar) {
	var pageNumber = $('#' + pageBar).attr("pageNumber");
	if (0 < pageNumber) {
		$('#' + pageBar).attr("pageNumber", pageNumber - 1);

		pageBar_callUpdate(pageBar);
	}
}

function pageBar_nextPage(pageBar) {
	var pageNumber = $('#' + pageBar).attr("pageNumber");

	if (pageNumber < $('#' + pageBar).attr("pagesAmount") - 1) {
		$('#' + pageBar).attr("pageNumber", pageNumber + 1);

		pageBar_callUpdate(pageBar);
	}
}

function pageBar_setPage(pageBar, n) {

	$('#' + pageBar).attr("pageNumber", n);

	pageBar_callUpdate(pageBar);

}

function pageBar_setSize(pageBar, s) {
	$('#' + pageBar).attr("pageSize", s);

	pageBar_callUpdate(pageBar);
}

function pageBar_callUpdate(pageBar) {
	alert(3);
	var updateFunc = $('#' + pageBar).attr("updateFunc");
alert(window[updateFunc]);
	window[updateFunc](pageBar);
	alert(5);
}

function pageBar_update(pageBar) {
	var fragID = $('#' + pageBar).attr("fragID");
	var frag = $('#' + pageBar).attr("frag");
	var attrs = {
		pageNumber : $('#' + pageBar).attr("pageNumber"),
		pageSize : $('#' + pageBar).attr("pageSize")
	};

	$('#' + pageBar).each(function() {
		$.each(this.attributes, function(attr) {
			if (this.specified) {
				attrs[this.name] = this.value;
			}
		});
	});

	var dataUrl = $('#' + pageBar).attr("dataUrl");

	$.ajax({
		type : "GET",
		url : dataUrl,
		data : attrs,
		dataType: "json",
		success : function(resp) {
			appendFragment(fragID, frag, attrs, resp);
		}
	});
}

function stdItem(pageNumber, pageSize) {
	var res;

	$.ajax({
		type : "POST",
		url : "/controls/itemBrowser",
		data : {
			pageNumber : pageNumber,
			pageSize : pageSize
		},
		datatype : json,
		success : function(resp) {

			res = resp;
		},
		async : false
	});

	return res;
}

function loadPagedIB(pagedItemBrowserCode, itemSource, pageNumber, pageSize) {
	$(pagedItemBrowserCode).data("itemSource", itemSource);
	$(pagedItemBrowserCode).data("pageNumber", pageNumber);
	$(pagedItemBrowserCode).data("pageSize", pageSize);
	$(pagedItemBrowserCode).data("itemsAmount", 0);
	$(pagedItemBrowserCode).data("pagesAmount", 0);
}

function prevPage(pagedIB) {
	var pageNumber = $('#' + pagedIB).data("pageNumber");
	if (0 < pageNumber) {
		$('#' + pagedIB).data("pageNumber", pageNumber - 1);

		updateBox(pagedIB);
	}
}

function nextPage(pagedIB) {
	var pageNumber = $('#' + pagedIB).data("pageNumber");

	if (pageNumber < $('#' + pagedIB).data("pagesAmount") - 1) {
		$('#' + pagedIB).data("pageNumber", pageNumber + 1);

		updateBox(pagedIB);
	}
}

function setPage(pagedIB, n) {
	$('#' + pagedIB).data("pageNumber", n);

	updateBox(pagedIB);
}

function setSize(pagedIB, s) {
	$('#' + pagedIB).data("pageSize", s);

	updateBox(pagedIB);
}

function updateBox(pagedIB) {
	var pageNumber = $('#' + pagedIB).data("pageNumber");
	var pageSize = $('#' + pagedIB).data("pageSize");

	var resp = eval($('#' + pagedIB).data("itemSource"));

	$(pagedItemBrowserCode).data("itemsAmount", res.itemsAmount);
	$(pagedItemBrowserCode).data("pagesAmount", res.pagesAmount);
	$('#' + pagedIB + ">.itemBrowser").html(resp.browser);
}

function searchBox_pageBar_update(pageBar) {
	alert(1);
	var fragID = $('#' + pageBar).attr("fragID");
	var frag = $('#' + pageBar).attr("frag");
	var attrs = {
		pageNumber : $('#' + pageBar).attr("pageNumber"),
		pageSize : $('#' + pageBar).attr("pageSize")
	};

	$('#' + pageBar).each(function() {
		$.each(this.attributes, function(attr) {
			if (this.specified) {
				attrs[this.name] = this.value;
			}
		});
	});
	alert(33);
	var cbs = document.getElementsByClassName("searchCB");
	
	for (var i = 0; i < cbs.length; i++) {
		if (cbs[i].checked) {
			alert(cbs[i].value);
			alert($("#" + cbs[i].value + "TB").val());
			attrs[cbs[i].value] = $("#" + cbs[i].value + "TB").val();
		}
	}

	var dataUrl = $('#' + pageBar).attr("dataUrl");

	$.ajax({
		type : "GET",
		url : dataUrl,
		data : attrs,
		dataType: "json",
		success : function(resp) {

			appendFragment(fragID, frag, attrs, resp);

		}
	});
}

function itemBrowser_showMore()
{
	
}