package devPackage.builders.version;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;

import org.w3c.dom.Node;

import devPackage.builders.utils.XMLTool;

public class VersionBuilder
{
	public static String GetVersion(String pomPath)
	{
		XMLTool pom = XMLTool.Open(pomPath);		
		if(pom == null) { return null; }
		
		Node node = pom.GetNode("project", "version");
		if(node == null) { return null; }
		
		return node.getNodeValue();
	}
	
	public static void Update(String file, String prop, String val)
	{
		try
		{
			BufferedReader reader = new BufferedReader(new FileReader(file));
			StringBuilder sb = new StringBuilder();
			
			String line;
			String code = "{" + prop + "}";
			
			while((line = reader.readLine()) != null)
			{
				if(line.contains(code))
				{
					sb.append(val + " " + "/*{version}*/");
				}
				else
				{
					sb.append(line);
				}
				
				sb.append('\n');
			}
			
			reader.close();
			
			BufferedWriter writer = new BufferedWriter(new FileWriter(file));
			writer.write(sb.toString());
			writer.close();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	public static void main(String[] args)
	{
		String version = GetVersion("pom.xml");
		
		if(version == null) { return; }
		
		Update("src/main/java/com/artstore/Core.java", "version", "\t\tprivate static final String version = \"" + version + "\";");
	}
}
