package devPackage.builders.resource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.artstore.permissions.PermissionMode;

public class EnumXMLUtils
{
	private static final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

	public static Document OpenFile(String path)
	{
		try
		{
			File fXmlFile = new File(path);

			if (!fXmlFile.exists())
			{
				return null;
			}

			DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();

			return dBuilder.parse(fXmlFile);
		}
		catch (ParserConfigurationException | SAXException | IOException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	public static ArrayList<PermObj> DeserializeXML(Document xmlDoc)
	{
		ArrayList<PermObj> res = new ArrayList<PermObj>();
		NodeList nodeList = xmlDoc.getChildNodes();
		NodeList permsList = null;

		for (int i = 0; i < nodeList.getLength(); i++)
		{
			if (nodeList.item(i).getNodeName().equals("permissions"))
			{
				permsList = nodeList.item(i).getChildNodes();

				break;
			}
		}
		if (permsList == null)
		{
			return null;
		}

		for (int i = 0; i < permsList.getLength(); i++)
		{
			Node currNode = permsList.item(i);

			if (!currNode.getNodeName().equals("permission") || currNode.getNodeType() != Node.ELEMENT_NODE
					|| !((Element) currNode).hasAttribute("name") && ((Element) currNode).hasAttribute("code"))
			{
				continue;
			}

			Element currElement = ((Element) currNode);

			PermObj permObj = new PermObj();
			permObj.setName(currElement.getAttribute("name"));
			permObj.setCode(currElement.getAttribute("code"));
			permObj.setPermMode(currElement.hasAttribute("mode") ? currElement.getAttribute("mode") : null);
			permObj.setPermissionLevel(currElement.hasAttribute("level") ? Integer.parseInt(currElement.getAttribute("level")) : 0);

			res.add(permObj);
		}

		return res;
	}

	public static boolean UpdateFile(String path, String data)
	{
		BufferedWriter writer = null;

		try
		{
			writer = new BufferedWriter(new FileWriter(path));
			writer.write(data);

			return true;
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
		finally
		{
			if (writer != null)
			{
				try
				{
					writer.close();
				}
				catch (IOException e)
				{
					e.printStackTrace();
				}
			}
		}

		return false;
	}

	public static boolean T(String package_, String enumName, String enumFilePath, String xmlPath, ArrayList<PermObj> objs)
	{
		try
		{
			BufferedReader br = new BufferedReader(new FileReader(enumFilePath));
			StringBuilder sb = new StringBuilder();
			String line;

			while ((line = br.readLine()) != null)
			{
				if (line.contains("/*START*/"))
				{
					sb.append("/*START*/\n");
					
					for (int i = 0; i < objs.size(); i++)
					{
						PermObj p = objs.get(i);
						sb.append('\t');
						sb.append(p.getName());
						sb.append("(\"");
						sb.append(p.getCode());
						sb.append("\", PermissionMode.");

						if (p.getPermMode() == null || PermissionMode.GetEquivalent(p.getPermMode()) == null)
						{
							sb.append(PermissionMode.GetDefault().toString());
						} else
						{
							sb.append(PermissionMode.GetEquivalent(p.getPermMode()));
						}
						System.out.println("test");
						sb.append(", ");
						sb.append(p.getPermissionLevel());
						if (i < objs.size() - 1)
						{
							sb.append("),");
						} else
						{
							sb.append(");");
						}
						
						sb.append('\n');
					}
					
					do
					{
						line = br.readLine();
						
						if(line == null) 
						{
							br.close();
							return false;
						}
					}
					while(!line.contains("/*END*/"));
					
					sb.append("/*END*/");
				} else
				{
					sb.append(line);
				}

				sb.append('\n');
			}
			
			br.close();
			BufferedWriter bw = new BufferedWriter(new FileWriter(enumFilePath));
			bw.write(sb.toString());
			bw.close();
			
			return true;
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
		
		return false;
	}

	public static int UpdatePermsEnum(String package_, String enumName, String enumFilePath, String xmlPath)
	{
		Document doc = OpenFile(xmlPath);
		if (doc == null)
		{
			return 1;
		}

		ArrayList<PermObj> objs = DeserializeXML(doc);
		if (objs == null)
		{
			return 2;
		}

		T(package_, enumName, enumFilePath, xmlPath, objs);

		return 0;
	}
}
