package com.artstore.web.utils;

import java.util.ArrayList;
import java.util.List;

public class TitleCreator
{
	List<String> titles = new ArrayList<>();
	
	public TitleCreator() { }
	
	public static TitleCreator Create(String title)
	{
		TitleCreator res = new TitleCreator();
		res.Add(title);
		
		return res;
	}
	
	public TitleCreator Add(String title)
	{
		titles.add(title);
		
		return this;
	}
	
	public String Get()
	{
		if(titles.size() < 1) { return ""; }
		
		StringBuilder sb = new StringBuilder();
		
		for(int i = 0; i < titles.size() - 1; i++)
		{
			sb.append(titles.get(i));
			sb.append(" - ");
		}
		
		sb.append(titles.get(titles.size() - 1));
		
		return sb.toString();
	}
}
