package com.artstore.web.thymeleaf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.thymeleaf.context.Context;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IAttribute;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;

public class ControlTagProcessor extends AbstractAttributeTagProcessor
{
	private SpringTemplateEngine templateEngine;

	protected ControlTagProcessor(String dialectPrefix, SpringTemplateEngine templateEngine)
	{
		super(TemplateMode.HTML, dialectPrefix, ControlDialect.CONTROL_TAG, false, ControlDialect.CONTROL_PATH_ATTR,
				false, ControlDialect.PRECEDENCE, true);

		this.templateEngine = templateEngine;
	}

	@Override
	protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName,
			String attributeValue, IElementTagStructureHandler structureHandler)
	{
		Map<String, Object> map = new HashMap<String, Object>();
		for(IAttribute at:tag.getAllAttributes())
		{
			AttributeName an = at.getAttributeDefinition().getAttributeName();

			if (an.isPrefixed() && an.getPrefix().equals(this.getDialectPrefix()))
			{
				map.put(at.getAttributeDefinition().getAttributeName().getAttributeName(), at.getValue());
			}
		}

		Context controlContext = new Context(context.getLocale(), map);

		IModelFactory modelFactory = context.getModelFactory();
		modelFactory.parse(context.getTemplateData(), templateEngine.process(attributeValue, controlContext));
	}

	protected Map<String, IProcessableElementTag> Parse(IModel model, ITemplateContext context)
	{		
		Map<String, IProcessableElementTag> res = new HashMap<>();

		for(int i = 0;i < model.size();i++)
		{
			ITemplateEvent e0 = model.get(i);

			if (e0 instanceof IProcessableElementTag)
			{
				IProcessableElementTag e1 = (IProcessableElementTag) e0;
				
				if (e1.getElementCompleteName().equals(ControlDialect.FIELD_TAG))
				{
					String name = e1.getAttributeValue(ControlDialect.FIELD_NAME_ATTR);

					res.put(name, e1);
				}
			}
		}
		
		return res;
	}
	
	protected Map<String, IProcessableElementTag> Parse(ITemplateContext context)
	{		
		Map<String, IProcessableElementTag> res = new HashMap<>();
		System.out.println(context.getTemplateData().getTemplate());
		List<IProcessableElementTag> list = context.getElementStack();
		for(int i = 0;i < list.size();i++)
		{
			IProcessableElementTag e1 = list.get(i);
			System.out.println(context.getTemplateData().getTemplate());
			if (e1.getElementCompleteName().equals(ControlDialect.FIELD_TAG))
			{
				String name = e1.getAttributeValue(ControlDialect.FIELD_NAME_ATTR);
				
				res.put(name, e1);
			}
		}

		return res;
	}
}
