package com.artstore.web.thymeleaf;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Component;
import org.thymeleaf.dialect.AbstractProcessorDialect;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;

@Component
public class ControlDialect extends AbstractProcessorDialect
{
	public static final String   CONTROL_TAG    = "control";
	public static final String   CONTROL_PREFIX = "ctrl";
	public static final String   CONTROL_PATH_ATTR = "name";
	public static final String   FIELD_TAG      = "field";
	public static final String   FIELD_NAME_ATTR      = "name";

	static final int             PRECEDENCE     = 1000;

	private SpringTemplateEngine templateEngine;

	public ControlDialect(@Autowired AutowireCapableBeanFactory beanFactory)
	{
		super("ArtStore Control Dialect", CONTROL_PREFIX, PRECEDENCE);
		ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
		templateResolver.setPrefix("templates");
		templateResolver.setSuffix(".html");
		templateResolver.setTemplateMode("HTML5");

		beanFactory.autowireBean(templateResolver);

		templateEngine = new SpringTemplateEngine();
		templateEngine.setTemplateResolver(templateResolver);
		beanFactory.autowireBean(templateEngine);
	}

	@Override
	public Set<IProcessor> getProcessors(String dialectPrefix)
	{
		final Set<IProcessor> processors = new HashSet<IProcessor>();

		processors.add(new ControlTagProcessor(dialectPrefix, templateEngine));

		return processors;
	}
}
