package com.artstore.status;

import javax.persistence.AttributeConverter;

import com.artstore.ArtStoreApplication;

public enum PaymentStatus
{
	Corrupted(ArtStoreApplication.GLOBAL_STATUS_CORRUPTION_ID, ArtStoreApplication.GLOBAL_STATUS_CORRUPTION_DESC, false),
	Waiting(0, "Waiting for payment arrival", true),
	Cancelled(1, "Payment has been cancelled", false),
	Expired(2, "Payment period has been exceeded", false),
	Posted(3, "All required money have arrived", true),
	Finalized(4, "Payment has been finalized", true);
	
	int id;
	String title;
	String desc;
	boolean isPossible;
	
	PaymentStatus(int id, String title, String desc, boolean isPossible)
	{
		this.id = id;
		this.title = title;
		this.desc = desc;
		this.isPossible = isPossible;
	}
	
	PaymentStatus(int id, String desc, boolean isPossible)
	{
		this.id = id;
		this.title = name();
		this.desc = desc;
		this.isPossible = isPossible;
	}
	
	public int GetID()
	{
		return id;
	}
	
	public static class PaymentStatusConverter implements AttributeConverter<PaymentStatus, Integer>
	{
		@Override
		public Integer convertToDatabaseColumn(PaymentStatus attribute)
		{
			return attribute.GetID();
		}

		@Override
		public PaymentStatus convertToEntityAttribute(Integer dbData)
		{
			for(PaymentStatus paymentStatus : PaymentStatus.values())
			{
				if(dbData.equals(paymentStatus.GetID()))
				{
					return paymentStatus;
				}
			}
			
			return PaymentStatus.Corrupted;
		}
	}
}
