package com.artstore.status;

import javax.persistence.AttributeConverter;

import com.artstore.ArtStoreApplication;

public enum OrderStatus
{	
	Corrupted(ArtStoreApplication.GLOBAL_STATUS_CORRUPTION_ID, ArtStoreApplication.GLOBAL_STATUS_CORRUPTION_DESC),
	Disapproved(-2, "This order has been denied by worker"),
	Cancelled(-1, "This order has been cancelled by customer"),
	Requested(0, "Order has been placed by customer"),
	Approved(1, "Order has been approved by worker"),
	Paid(2, "Order payment has been made"),
	Sent(3, "Ordered items has been sent to customer"),
	Delivered(4, "Customer confirmed items delivery"),
	Finalized(5, "Order has been finalized (set by worker)");
	
	int id;
	String title;
	String desc;
	
	OrderStatus(int id, String title, String desc)
	{
		this.id = id;
		this.title = title;
		this.desc = desc;
	}
	
	OrderStatus(int id, String desc)
	{
		this.id = id;
		this.title = this.name();
		this.desc = desc;
	}
	
	OrderStatus(int id)
	{
		this(id, "");
	}
	
	public int GetID()
	{
		return id;
	}
	
	public static class OrderStatusConverter implements AttributeConverter<OrderStatus, Integer>
	{
		@Override
		public Integer convertToDatabaseColumn(OrderStatus attribute)
		{
			return attribute.GetID();
		}

		@Override
		public OrderStatus convertToEntityAttribute(Integer dbData)
		{
			for(OrderStatus orderStatus : OrderStatus.values())
			{
				if(dbData.equals(orderStatus.GetID()))
				{
					return orderStatus;
				}
			}
			
			return OrderStatus.Corrupted;
		}
	}
}
