package com.artstore.repositories;

import java.util.UUID;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.stereotype.Repository;

import com.artstore.account.Account;
import com.artstore.account.InfoAccount;

@Repository
public interface AccountRepository extends PagingAndSortingRepository<Account, UUID>{
	Account findByUsername(String username);
	
	Account findByMailbox(String mailbox);
	
	Page<? extends InfoAccount> findAllProjectedBy(Pageable pageable);
}
