package com.artstore.pojo.account;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.validation.constraints.Email;

import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.GenericGenerator;

import com.artstore.permissions.IPermissible;
import com.artstore.pojo.Group;

@Entity
public class Account implements Serializable//, IPermissible
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -659180091212557800L;

	@Column(name = "uniqueId", columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	private UUID	uniqueId;

	@Column(name = "username", nullable = false)
	private String	username;

	@Column(name = "password", nullable = false)
	private byte[]	password;
	
	@Column(name = "passwordSalt", nullable = false)
	private byte[]	passwordSalt;
	
	private boolean isActivated = false;

	@Column(name = "creationDate", nullable = false)
	@CreationTimestamp
	private Date	creationDate;

	@JoinColumn(name = "`group`", nullable = true)
	@OneToOne(targetEntity=Group.class)
	private Group group;
	
	@Email
	private String mailbox;

	public Account()
	{
	}

	public UUID getUniqueId()
	{
		return uniqueId;
	}

	public void setUniqueId(UUID uniqueId)
	{
		this.uniqueId = uniqueId;
	}

	public String getUsername()
	{
		return username;
	}

	public void setUsername(String username)
	{
		this.username = username;
	}

	public byte[] getPassword()
	{
		return password;
	}

	public void setPassword(byte[] password)
	{
		this.password = password;
	}
	
	public byte[] getPasswordSalt()
	{
		return passwordSalt;
	}

	public void setPasswordSalt(byte[] passwordSalt)
	{
		this.passwordSalt = passwordSalt;
	}

	public Boolean getIsActivated()
	{
		return isActivated;
	}

	public void setIsActivated(Boolean isActivated)
	{
		this.isActivated = isActivated;
	}

	public Date getCreationDate()
	{
		return creationDate;
	}

	public void setCreationDate(Date creationDate)
	{
		this.creationDate = creationDate;
	}

	public Group getGroup()
	{
		return group;
	}

	public void setGroup(Group group)
	{
		this.group = group;
	}

	public String getMailbox()
	{
		return mailbox;
	}

	public void setMailbox(String mailbox)
	{
		this.mailbox = mailbox;
	}
}
