package com.artstore.pojo;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.artstore.log.LogLevel;

@Entity
@Table(name="'logs'")
public class LogEntity
{
	@Column(name = "uniqueId", columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	private Long	uniqueId;
	
	@Column(name = "logLevel", nullable = false)
	@Convert(converter = LogLevel.LogLevelConverter.class)
	private LogLevel logLevel;
	
	private String title;
	
	private String log;
}
