package com.artstore.pojo;

import java.io.Serializable;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.artstore.permissions.PermissibleGroup;

@Entity
@Table(name = "`group`")
public class Group extends PermissibleGroup<UUID> implements Serializable
{
	private static final long serialVersionUID = 3760544663846994986L;

	public Group(UUID id, String name)
	{
		super(id, name);
	}
	
	@Column(name = "uniqueId", columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	public UUID getUniqueId()
	{
		return GetID();
	}

	public void setUniqueId(UUID uniqueId)
	{
		this.id = uniqueId;
	}

	@Column(name = "name", updatable = true, nullable = false)
	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	@Column(name = "description", updatable = true, nullable = true)
	public String getDescription()
	{
		return description;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}

	@Override
	public String GetCode()
	{
		return "group{" + GetID().toString() + "}:" + name;
	}
}
