package com.artstore.pojo;

import java.io.Serializable;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

import org.hibernate.annotations.GenericGenerator;

@Entity
public class Currency implements Serializable
{
	private static final long serialVersionUID = -8980115379323167586L;

	@Column(name = "uniqueId", columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	private UUID	uniqueId;
	
	private String title;
	private String symbol;
	
	@Column(name = "`desc`")
	private String desc;	
	
	private boolean isAvailable = true;
	
	public Currency() { }

	public UUID getUniqueId()
	{
		return uniqueId;
	}

	public void setUniqueId(UUID uniqueId)
	{
		this.uniqueId = uniqueId;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getSymbol()
	{
		return symbol;
	}

	public void setSymbol(String symbol)
	{
		this.symbol = symbol;
	}

	public String getDesc()
	{
		return desc;
	}

	public void setDesc(String desc)
	{
		this.desc = desc;
	}

	public boolean isAvailable()
	{
		return isAvailable;
	}

	public void setAvailable(boolean isAvailable)
	{
		this.isAvailable = isAvailable;
	}
}
