package com.artstore.permissions.uuid;

import java.io.Serializable;
import java.util.UUID;

import javax.persistence.MappedSuperclass;

import com.artstore.permissions.IPermissibleGroup;

@MappedSuperclass
public abstract class UUIDPermissibleGroup<TID extends Serializable> extends UUIDPermissibleEntity implements IPermissibleGroup<UUID>
{
	private static final long serialVersionUID = -3950178577471939808L;
	
	protected String name;
	protected String description;
	
	public UUIDPermissibleGroup(UUID id, String name, String description)
	{
		super(id);
		
		this.name = name;
		this.description = description;
	}
	
	public UUIDPermissibleGroup(UUID id, String name)
	{
		this(id, name, null);
	}
	
	public UUIDPermissibleGroup()
	{
		this(null, null, null);
	}

	public String GetName()
	{
		return name;
	}

	public String GetDescription()
	{
		return description;
	}
}
