package com.artstore.permissions.uuid;

import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import org.hibernate.annotations.GenericGenerator;

import com.artstore.permissions.PermissibleEntity;

@MappedSuperclass
public class UUIDPermissibleEntity extends PermissibleEntity<UUID>
{
	private static final long serialVersionUID = 7658540772209522368L;

	@Id
	@GeneratedValue(generator = "UUID")
	@GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
	@Column(columnDefinition = "BINARY(16)", updatable = false, nullable = false)
	private UUID id;
	
	public UUIDPermissibleEntity(UUID id)
	{
		super(id);
	}
	
	@Override
	public UUID GetID()
	{
		return id;
	}

	@Override
	protected void SetID(UUID id)
	{
		this.id = id;
	}
}
