package com.artstore.permissions.permissions.string;

import java.util.HashMap;
import java.util.Map;

import com.artstore.permissions.IPermission;

public class WrapperPermissionManager
{
	private static final Map<String, IPermission[]> registeredWrappers = new HashMap<>();

	public static boolean RegisterWrapper(String code, IPermission... linkedPerms)
	{
		if (registeredWrappers.containsKey(code))
		{
			return false;
		}
		
		registeredWrappers.put(code, linkedPerms);
		
		return true;
	}
	
	public static IPermission[] Get(String code)
	{
		return registeredWrappers.get(code);
	}
}
