package com.artstore.permissions.permissions.string;

import com.artstore.permissions.IPermission;
import com.artstore.permissions.PermissionMode;
import com.artstore.permissions.permissions.IStringPermission;

public enum StringPermissions implements IStringPermission
{
/*START*/
	LOGIN("auth.login", PermissionMode.ALLOWED, 0),
	AddItem("item.add", PermissionMode.ALLOWED, 0),
	ALL("*", PermissionMode.ALLOWED, 0),
	Admin("admin.*", PermissionMode.ALLOWED, 0),
/*END*/
	Worker("worker.*", PermissionMode.ALLOWED, 0);

	String         code;
	PermissionMode recommendedPermMode;
	int permissionLevel;

	StringPermissions(String code, PermissionMode recommendedPermMode, int permissionLevel)
	{
		this.code = code;
		this.recommendedPermMode = recommendedPermMode;
		this.permissionLevel = permissionLevel;
	}
	
	StringPermissions(String code, PermissionMode recommendedPermMode)
	{
		this(code, recommendedPermMode, 0);
	}

	public String GetCode()
	{
		return code;
	}

	public PermissionMode GetRecommendedMode()
	{
		return recommendedPermMode;
	}
	
	public int GetPermissionLevel()
	{
		return permissionLevel;
	}
	
	@Override
	public boolean Implies(IPermission perm)
	{
		if (perm instanceof IStringPermission)
		{
			IStringPermission perm0 = (IStringPermission) perm;

			return perm0.GetMode() == PermissionMode.ALLOWED && IsChild(perm0.GetCode(), GetCode());
		} else if (perm instanceof StringPermissions)
		{
			return IsChild(((StringPermissions) perm).GetCode(), GetCode());
		}

		return false;
	}

	public static boolean IsChild(String childCode, String superCode)
	{
		return childCode.equals(superCode) || (superCode.length() < childCode.length()
				&& childCode.startsWith(superCode) && childCode.charAt(superCode.length()) == '.');
	}

	@Override
	public PermissionMode GetMode()
	{
		return GetRecommendedMode();
	}
}
