package com.artstore.permissions.permissions.string;

import com.artstore.permissions.IPermission;
import com.artstore.permissions.PermissionMode;
import com.artstore.permissions.permissions.IStringPermission;
import com.artstore.permissions.permissions.Permission;

public class StringPermission extends Permission implements IStringPermission
{
	private static final long serialVersionUID = -5470074902351195538L;
	
	String code;
	
	public StringPermission(PermissionMode mode, String code)
	{
		super(mode);
		
		this.code = code;
	}

	public String GetCode()
	{
		return code;
	}

	@Override
	public boolean Implies(IPermission perm)
	{
		return perm instanceof IStringPermission && StringPermissions.IsChild(((IStringPermission)perm).GetCode(), GetCode());
	}
}
