package com.artstore.permissions.permissions;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.permissions.IPermission;

@Component
public class RootPermission implements IPermission
{
	private static final long serialVersionUID = 4193827924656927944L;
	
	private transient Core core;
	
	@Autowired
	public RootPermission(Core core)
	{
		this.core = core;
	}
	
	public boolean IsRootEnabled()
	{
		return core.GetAccountManager().IsRootSupported();
	}
	
	@Override
	public boolean Implies(IPermission perm)
	{
		return IsRootEnabled();
	}
}
