package com.artstore.permissions;

import com.artstore.permissions.permissions.StringPermission;

public enum StringPermissions implements IPermission
{
/*START*/
	LOGIN("auth.login", PermissionMode.ALLOWED),
	AddItem("item.add", PermissionMode.ALLOWED);
/*END*/

	String         code;
	PermissionMode recommendedPermMode;

	StringPermissions(String code, PermissionMode recommendedPermMode)
	{
		this.code = code;
		this.recommendedPermMode = recommendedPermMode;
	}

	public String GetCode()
	{
		return code;
	}

	public PermissionMode GetRecommendedMode()
	{
		return recommendedPermMode;
	}

	@Override
	public boolean IsChildOf(IPermission perm)
	{
		if (perm instanceof StringPermission)
		{
			StringPermission perm0 = (StringPermission) perm;

			return perm0.GetMode() == PermissionMode.ALLOWED && IsChild(GetCode(), perm0.GetCode());
		} else if (perm instanceof StringPermissions)
		{
			return IsChild(GetCode(), ((StringPermissions) perm).GetCode());
		}

		return false;
	}

	public static boolean IsChild(String childCode, String superCode)
	{
		return childCode.equals(superCode) || (superCode.length() < childCode.length()
				&& childCode.startsWith(superCode) && childCode.charAt(superCode.length()) == '.');
	}
}
