package com.artstore.permissions;

public enum PermissionMode
{
	ALLOWED,
	FORBIDDEN;
	
	public static String GetEquivalent(String name)
	{
		for(PermissionMode mode : PermissionMode.values())
		{
			if(mode.toString().equalsIgnoreCase(name))
			{
				return mode.toString();
			}
		}
		
		return null;
	}
	
	public static PermissionMode GetDefault()
	{
		return ALLOWED;
	}
}