package com.artstore.permissions;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.account.Group;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.IPermissionManager;
import com.artstore.repositories.GroupRepository;

@Component
public class PermissionManager extends AbstractManager implements IPermissionManager<UUID>
{
	private GroupRepository groupRepo;
	
	List<IPermissibleGroup<UUID>> groups = new ArrayList<>();
	
	@Autowired
	public PermissionManager(Core core, GroupRepository groupRepo)
	{
		super(core);
		
		this.groupRepo = groupRepo;
	}
	
	@Override
	@Transactional
	public boolean Initialize()
	{
		if(Core().IsInitRequested())
		{		
			if(!groupRepo.findByName("Klient").isPresent())
			{
				Group group = new Group();
				group.setName("Klient");
				group.setDescription("Grupa klientów");
				
				groupRepo.save(group);
			}
			
			if(!groupRepo.findByName("Pracownik").isPresent())
			{
				Group group = new Group();
				group.setName("Pracownik");
				group.setDescription("Grupa pracowników");
				
				groupRepo.save(group);
			}
			
			if(!groupRepo.findByName("Administrator").isPresent())
			{
				Group group = new Group();
				group.setName("Administrator");
				group.setDescription("Grupa administratorów");
				
				groupRepo.save(group);
			}
		}
		
		groups.addAll(groupRepo.findAll());
		
		return super.Initialize();
	}

	@Override
	public boolean Dispose()
	{
		return super.Dispose();
	}
	
	@Override
	public IPermissibleGroup<UUID> GetGroup(UUID Uid)
	{
		for(IPermissibleGroup<UUID> group : groups)
		{
			if(group.GetID().equals(Uid))
			{
				return group;
			}
		}
		
		return null;
	}
	
	@Override
	public IPermissibleGroup<UUID> GetGroup(String name)
	{
		for(IPermissibleGroup<UUID> group : groups)
		{
			if(group.GetName().equals(name))
			{
				return group;
			}
		}
		
		return null;
	}

	@Override
	public void Validate(IPermissible<?> ent, IPermission perm)
	{
		if(!ent.IsPermittedTo(perm))
		{
			throw new InsufficientPermissionsException(ent, perm);
		}
	}
}
