package com.artstore.permissions;

import java.io.Serializable;

import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class PermissibleGroup<TID extends Serializable> extends PermissibleEntity<TID> implements IPermissibleGroup<TID>
{
	private static final long serialVersionUID = -3950178577471939808L;
	
	protected String name;
	protected String description;
	
	public PermissibleGroup(TID id, String name, String description)
	{
		super(id);
		
		this.name = name;
		this.description = description;
	}
	
	public PermissibleGroup(TID id, String name)
	{
		this(id, name, null);
	}
	
	public PermissibleGroup()
	{
		this(null, null, null);
	}

	public String GetName()
	{
		return name;
	}

	public String GetDescription()
	{
		return description;
	}
}
