package com.artstore.permissions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.ElementCollection;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class PermissibleEntity<TID extends Serializable> implements IPermissible<TID>
{
	private static final long serialVersionUID = 7658540772209522368L;
	
	@ElementCollection
	private List<IPermissible<TID>> supers = new ArrayList<>();
	
	@ElementCollection
	private List<IPermission> perms = new ArrayList<>();
	
	public PermissibleEntity(TID id)
	{
		SetID(id);
	}
	
	public PermissibleEntity()
	{
		this(null);
	}
	
	public abstract TID GetID();
	protected abstract void SetID(TID id);
	
	@Override
	public List<IPermissible<TID>> GetSupers()
	{
		return supers;
	}

	@Override
	public List<IPermission> GetPermissions()
	{
		return perms;
	}
	
	@Override
	public boolean IsPermittedTo(IPermission perm)
	{
		for(IPermission i : perms)
		{
			if(i.Implies(perm))
			{
				return true;
			}
		}
		
		for(IPermissible<TID> i : supers)
		{
			if(i.IsPermittedTo(perm))
			{
				return true;
			}
		}
		
		return false;
	}

	@Override
	public boolean Grant(IPermission perm)
	{
		perms.add(perm);
		
		return true;
	}

	@Override
	public boolean Revoke(IPermission perm)
	{
		while(perms.remove(perm));
		
		return true;
	}
}
