package com.artstore.permissions;

import java.util.ArrayList;
import java.util.List;

public class Permissible implements IPermissible
{
	List<IPermissible> supers = new ArrayList<>();
	List<IPermission> perms = new ArrayList<>();

	@Override
	public List<IPermissible> GetSupers()
	{
		return supers;
	}

	@Override
	public List<IPermission> GetPermissions()
	{
		return perms;
	}
	
	@Override
	public boolean IsPermittedTo(IPermission perm)
	{
		for(IPermission i : perms)
		{
			if(perm.IsChildOf(i))
			{
				return true;
			}
		}
		
		for(IPermissible i : supers)
		{
			if(i.IsPermittedTo(perm))
			{
				return true;
			}
		}
		
		return false;
	}

	@Override
	public boolean Grant(IPermission perm)
	{
		perms.add(perm);
		
		return true;
	}

	@Override
	public boolean Revoke(IPermission perm)
	{
		while(perms.remove(perm));
		
		return true;
	}
}
