package com.artstore.permissions;

public class InsufficientPermissionsException extends RuntimeException
{
	private static final long serialVersionUID = 1125427642081858445L;
	
	IPermissible<?> entity;
	IPermission permission;
	
	public InsufficientPermissionsException(IPermissible<?> entity, IPermission permission)
	{
		super();
		
		this.entity = entity;
		this.permission = permission;
	}
	
	public IPermissible<?> GetEntity()
	{
		return entity;
	}

	public IPermission GetPermission()
	{
		return permission;
	}
}
