package com.artstore.permissions;

import java.io.Serializable;
import java.util.List;

public interface IPermissibleGroup<TID extends Serializable> extends IPermissible<TID>
{
	/**
	 * Returns ID of this group, valid within adequate Permission Managers (it is used to identify groups by Permission Manager).
	 * @return Group's ID
	 */
	TID GetID();
	
	String GetName();
	
	/**
	 * Returns list of permissions attributed to this group.
	 * @return List of permissions
	 */
	List<IPermission> GetPermissions();
}
