package com.artstore.permissions;

import java.io.Serializable;
import java.util.List;

import com.artstore.entity.IEntity;

public interface IPermissible<TID extends Serializable>  extends IEntity<TID>, Serializable
{
	/**
	 * Returns list of IPermissible objects which this object inherits permissions from.
	 * @return List of IPermissible objects
	 */
	 List<IPermissible<TID>> GetSupers();
	
	/**
	 * Returns list of permissions directly assigned to this object
	 * @return List of IPermission objects
	 */
	List<IPermission> GetPermissions();
	
	/**
	 * Checks if this object has been granted given permission.
	 * @param IPermission object to check
	 * @return True if yes, false if not.
	 */
	boolean IsPermittedTo(IPermission perm);
	
	boolean Grant(IPermission perm);
	boolean Revoke(IPermission perm);
}
