package com.artstore.permissions;

import java.util.List;

public interface IPermissibleGroup<TID>
{
	/**
	 * Returns ID of this group, valid within adequate Permission Managers (it is used to identify groups by Permission Manager).
	 * @return Group's ID
	 */
	TID GetID();
	
	/**
	 * Returns list of permissions attributed to this group.
	 * @return List of permissions
	 */
	List<IPermission> GetPermissions();
}
