package com.artstore.account;

import com.artstore.ArtStoreApplication;
import com.artstore.mail.MailManager;
import com.artstore.pojo.account.Account;

public class RegistrationManager
{
	public static void SendActivationMail(String to, String accName, String code)
	{
		MailManager.SendMail("art.store.art.store@gmail.com", to, "Art Store Activation Key", "Your code: /account/activate?account=" + accName + ";code="+ code);
	}
	
	protected static String GenerateActivationCode(Account account)
	{
		return "";// SecurityUtils.ToHex(SecurityUtils.Hash(account.getPassword(), account.getUsername().getBytes()));
	}
	
	public static boolean ActivateAccount(String account, String code)
	{
		Account acc = ArtStoreApplication.GetAM().FetchAccount(account);
		
		if(acc == null || acc.getIsActivated()) { return false; }
		
		String newCode = GenerateActivationCode(acc);
		
		if(newCode.equalsIgnoreCase(code))
		{
			ArtStoreApplication.GetAM().Activate(acc);
			
			
			return true;
		}
		
		return false;
	}
	
	public static boolean RegisterAccount(String username, String password, String email)
	{
		AccountManager aM = ArtStoreApplication.GetAM();
		
		if(aM.FetchAccount(username) != null) { System.out.println("istnieje"); return false; }
		
		return aM.CreateAccount(username, password, email);
	}
}
