package com.artstore.economy.payment;

import java.util.List;
import java.util.UUID;

import javax.persistence.EntityManager;

import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;

import com.artstore.ArtStoreApplication;
import com.artstore.economy.TransactionRequest;
import com.artstore.economy.event.IncomingTransactionEvent;
import com.artstore.economy.payment.event.PaymentFinalizedEvent;
import com.artstore.event.EventHandler;
import com.artstore.event.EventManager;
import com.artstore.event.IEventListener;
import com.artstore.pojo.Money;
import com.artstore.pojo.Payment;
import com.artstore.pojo.Transaction;
import com.artstore.repositories.PaymentRepository;

public class PaymentManager implements IEventListener
{
	EntityManager		em	= ArtStoreApplication.CreateEM();
	PaymentRepository	pr	= new JpaRepositoryFactory(em).getRepository(PaymentRepository.class);

	public Long GetPaidQuantity(Payment payment)
	{
		List<Transaction> list = payment.getSignedTransactions();
		long amount = 0;

		for (Transaction t : list)
		{
			amount += t.getAmount().getQuantity();
		}

		return amount;
	}

	public boolean BookTransaction(Payment payment, TransactionRequest req)
	{
		if (!payment.getAmount().IsCompatible(req.getAmount()))
		{
			return false;
		}

		Long leftToPay = payment.getAmount().getQuantity() - GetPaidQuantity(payment);

		Money exchangedMoney = leftToPay < req.getAmount().getQuantity()
				? new Money(leftToPay, payment.getAmount().getCurrency())
				: req.getAmount();
		Transaction transaction = Transaction.CreateTransaction(req.getPayer(), exchangedMoney);
		req.setApprovedTransaction(transaction);

		payment.getSignedTransactions().add(transaction);

		if (leftToPay < req.getAmount().getQuantity())
		{
			EventManager.CallEvent(new PaymentFinalizedEvent(payment));
		}

		return true;
	}

	@EventHandler
	public void onIncomingTransaction(IncomingTransactionEvent ev)
	{
		UUID uniqueId = ev.GetTransactionRequest().getPaymentUniqueId();
		if (uniqueId == null)
		{
			return;
		}

		Payment payment = pr.findByUniqueId(ev.GetTransactionRequest().getPaymentUniqueId());
		if (payment == null)
		{
			return;
		}

		if (BookTransaction(payment, ev.GetTransactionRequest()))
		{
			ev.setProcessed();
		}
	}
}
