package com.artstore.managers;

import javax.servlet.http.HttpSession;

import com.artstore.account.Account;
import com.artstore.entity.IEntity;

public interface ISessionManager<TID> extends IManager
{
	/**
	 * Checks if given session is linked and if link is valid.
	 * @param session HttpSession to check
	 * @return true when session's link is valid, otherwise false
	 */
	public boolean ValidateSession(HttpSession session);

	/**
	 * Returns ID of Entity linked to session.
	 * @param session Session from which Account ID is going to be extracted;
	 * @return ID of Entity that session is linked to; if session is not linked, then null
	 */
	public TID GetEntityID(HttpSession session);

	/**
	 * Returns Entity instance which session is linked to.
	 * @param session Session which is linked to returned Account;
	 * @return Instance of Entity which session is linked to; if session is not linked, then null
	 */
	public IEntity<TID> GetEntity(HttpSession session);
	
	public Account GetAccount(HttpSession session);

	/**
	 * Links session to given Entity.
	 * @param session Session to link;
	 * @param entity Entity which session is going to be linked to;
	 * @return Session ID if linking was successfull
	 */
	public TID LinkSession(HttpSession session, IEntity<TID> entity);

	/**
	 * Unlinks session.
	 * @param session Session to unlink;
	 * @return true if unlinking was successfull, false if unsuccessfull or session was already not linked
	 */
	public boolean UnlinkSession(HttpSession session);

	/**
	 * Adds session linkage data (or overwrites, if already exists) to given session
	 * @param session Session to refresh its linkage data;
	 * @return true if refreshing was successfull, false otherwise (i.e. if session is not linked)
	 */
	public boolean RefreshSessionLinkage(HttpSession session);
}
