package com.artstore.managers;

import java.io.Serializable;

import com.artstore.permissions.IPermissible;
import com.artstore.permissions.IPermissibleGroup;
import com.artstore.permissions.IPermission;

public interface IPermissionManager<TID extends Serializable> extends IManager
{
	/**
	 * Returns IPermGroup based on given ID.
	 * @param id ID of IPermGroup object
	 * @return
	 */
	public IPermissibleGroup<TID> GetGroup(TID id);
	
	/**
	 * Returns IPermGroup based on name.
	 * @param name Name of IPermGroup object
	 * @return
	 */
	public IPermissibleGroup<TID> GetGroup(String name);
	
	/**
	 * Checks if PermissionEntity has given Permission.
	 * If it isn't, then InsufficientPermissionsException is called.
	 * @param ent	Any IPermEntity
	 * @param perm	Any IPermission
	 */
	public void Validate(IPermissible<?> ent, IPermission perm);
}
