package com.artstore.managers;

import org.springframework.data.domain.Page;

import com.artstore.entity.IEntity;
import com.artstore.log.LogEntry;
import com.artstore.log.LogLevel;
import com.artstore.repositories.LogRepository;

public interface ILogManager extends ICRUDRepoManager<LogEntry<?>, Long, LogRepository>
{
	public <TID> Page<LogEntry<TID>> Fetch(int pageNumber, int pageSize);
	/**
	 * Pushes given log entry to database
	 * 
	 * @param logEntry LogEntry object to push
	 * @return LogEntry object if pushed successfully, otherwise null
	 */
	public <TID> LogEntry<TID> Post(LogEntry<TID> logEntry);

	/**
	 * Pushes requested log entry to database
	 * 
	 * @param logLevel    Log's level
	 * @param causer      Log's causer
	 * @param title       Log's title
	 * @param description Log's description
	 * @return LogEntry object if pushed successfully, otherwise null
	 */
	public default <TID> LogEntry<TID> Post(LogLevel logLevel, IEntity<TID> causer, String title, String description)
	{
		return Post(LogEntry.Create(logLevel, causer, title, description));
	}

	public default LogEntry<Void> Post(LogLevel logLevel, String causer, String title, String description)
	{
		return Post(LogEntry.Create(logLevel, causer, title, description));
	}
}
