package com.artstore.managers;

import java.util.List;
import java.util.UUID;

import org.springframework.data.domain.Page;

import com.artstore.item.Item;
import com.artstore.repositories.ItemRepository;

public interface IItemManager extends ICRUDRepoManager<Item, UUID, ItemRepository>
{
	public Item GetItem(UUID id);
	
	public List<Item> GetItems();

	public Page<Item> Fetch(int pageNumber, int pageSize);
	
	public Page<Item> Fetch(int pageNumber, int pageSize, String title, String author, String desc, Integer above,
			Integer below);
}
