package com.artstore.managers;

import com.artstore.event.IEvent;
import com.artstore.event.IEventListener;

public interface IEventManager extends IManager
{
	/**
	 * Registers given event listener.
	 * 
	 * @param eventListener IEventListener instace to be registered
	 * @return True - registered successfully; false - couldn't register.
	 */
	public boolean RegisterEventListener(IEventListener eventListener);

	/**
	 * Calls event.
	 * 
	 * @param event Event objecy to be called
	 * @return True - event called without problems; false - problem occurred,
	 *         aborted calling
	 */
	public boolean CallEvent(IEvent event);
}
