package com.artstore.managers;

import java.util.UUID;

import javax.transaction.Transactional;

import com.artstore.economy.CompositeMoney;
import com.artstore.economy.EconomyEntity;
import com.artstore.economy.Money;
import com.artstore.economy.Transfer;
import com.artstore.economy.TransferRequest;
import com.artstore.repositories.CurrencyRepository;
import com.artstore.repositories.EconomyRepository;

public interface IEconomyManager extends ICRUDRepoManager<EconomyEntity, UUID, EconomyRepository>
{
	public CurrencyRepository GetCurrencyRepo();
	
	public CompositeMoney CalcBalance(EconomyEntity entity);
	
	public boolean IsPossible(Transfer transfer);
	
	/** Posts incoming money transfer.
	 * @param t TransferRequest to be posted.
	 * @return	True if successful; false if transfer has been considered with negative effect
	 */
	boolean ApplyTransferRequest(TransferRequest request);
	
	@Transactional
	boolean PostTransfer(Transfer newTransfer);
	
	@Transactional
	default boolean PostTransfer(EconomyEntity source, EconomyEntity destination, Money money)
	{
		return PostTransfer(new Transfer(source, destination, money));
	}
	
	@Transactional
	default boolean PostTransfer(EconomyEntity destination, Money money)
	{
		return PostTransfer(null, destination, money);
	}
}
