package com.artstore.managers;

import javax.transaction.Transactional;

import org.springframework.data.repository.CrudRepository;

import com.artstore.entity.IEntity;

public interface ICRUDRepoManager<T extends IEntity<TID>, TID, TRepo extends CrudRepository<T, TID>> extends IRepoManager<T, TID, TRepo>
{
	@Transactional
	public default T Create(T entity)
	{
		if (entity == null || (entity.GetID() != null && GetRepo().existsById(entity.GetID())))
		{ return null; }
		
		return GetRepo().save(entity);
	}
	
	@Transactional
	public default boolean Delete(T entity)
	{
		if (entity == null || entity.GetID() == null || !GetRepo().existsById(entity.GetID()))
		{ return false; }
		
		GetRepo().delete(entity);
		
		return true;
	}
	
	@Transactional
	public default T Update(T entity)
	{
		if (entity == null || entity.GetID() == null || !GetRepo().existsById(entity.GetID()))
		{ return null; }
		
		return GetRepo().save(entity);
	}
}
