package com.artstore.managers;

import java.util.UUID;

import javax.servlet.http.HttpSession;

import org.springframework.data.domain.Page;

import com.artstore.account.Account;
import com.artstore.account.InfoAccount;
import com.artstore.repositories.AccountRepository;

public interface IAccountManager extends ICRUDRepoManager<Account, UUID, AccountRepository>
{
	public boolean IsRootSupported();
	
	public Iterable<Account> FetchAll();
	public Page<InfoAccount> Fetch(int pageNumber, int pageSize);
	
	public Account GetAccount(UUID id);
	public Account GetAccount(String username);
	public Account GetAccountByMail(String mail);
	
	public boolean VerifyCredentials(String username, String password);
	
	public String SetNewPassword(Account acc);
	public String SetNewPassword(Account acc, String psswd);
	
	public boolean SetNewMail(Account acc, String mail);
	public boolean SetPersonalData(Account acc, String name, String phoneNumber, String contactMail, String address);
	
	public UUID Login(String username, String password, HttpSession session);
	
	public default UUID Login(Account acc, String password, HttpSession session)
	{
		return Login(acc.getUsername(), password, session);
	}
}
