package com.artstore.economy;

import com.artstore.economy.event.IncomingTransactionEvent;
import com.artstore.event.EventManager;
import com.artstore.pojo.Money;

public class EconomyManager implements ITransactionProxy
{
	//private static List<ITransactionProxy> registeredProxies = new ArrayList<>();
	
	public EconomyManager()
	{
		
	}

	@Override
	public boolean ReceiveTransaction(TransactionRequest tReq)
	{
		IncomingTransactionEvent event = new IncomingTransactionEvent(tReq);
		
		EventManager.CallEvent(event);
		
		if(!event.isProcessed())
		{
			return false;
		}
		
		Money diff = Money.CreateDifference(tReq.amount, tReq.getApprovedTransaction().getAmount());
		
		if(0 < diff.getQuantity())
		{
			TransactionRequest back = TransactionRequest.CreateReversed(diff, tReq);
			return back.getTo().ReceiveTransaction(back);
		}
		
		return true;
	}
}
