package com.artstore.account;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.persistence.EntityManager;
import javax.servlet.http.HttpSession;

import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.artstore.ArtStoreApplication;
import com.artstore.pojo.account.Account;
import com.artstore.repositories.AccountRepository;

@Service
@Component
public class AccountManager
{
	public AccountRepository      ar;

	private final Map<UUID, UUID> sessionMap = new HashMap<>();

	public void Initialize()
	{
		ar = ArtStoreApplication.GetRepoFactory().getRepository(AccountRepository.class);

	}

	public boolean Login(String username, String password, HttpSession session)
	{
		Account acc = FetchAccount(username);
		if (acc == null)
		{
			return false;
		}
		
		System.out.println("Received password hash: " + SecurityUtils.ToHex(acc.getPassword()));

		if (SecurityUtils.ValidatePassword(password, acc.getPasswordSalt(), acc.getPassword()))
		{
			BindSession(session, acc.getUniqueId());

			return true;
		}

		return false;
	}

	@Transactional
	public void Activate(Account a)
	{
		// NIE DZIALA
		/*
		 * Account acc = ar.findByUniqueId(a.getUniqueId()); acc.setIsActivated(true);
		 * a.setIsActivated(true);
		 */

	}

	public Account FetchAccount(UUID uniqueId)
	{
		return ar.findByUniqueId(uniqueId);
	}

	public Account FetchAccount(String username)
	{
		return ar.findByUsername(username);
	}

	public static Account FetchAccount()
	{
		AccountRepository ar = new JpaRepositoryFactory(ArtStoreApplication.CreateEM())
				.getRepository(AccountRepository.class);

		List<Account> list = ar.findAll();

		return 0 < list.size() ? list.get(0) : null;
	}

	public boolean CreateAccount(String username, String password, String email)
	{
		EntityManager em = null;

		try
		{
			em = ArtStoreApplication.CreateEM();
			em.getTransaction().begin();

			byte[] salt = SecurityUtils.GenerateSalt();
			byte[] passwordHash = SecurityUtils.Hash(password, salt);
			
			System.out.println("Generated password hash: " + SecurityUtils.ToHex(passwordHash));
			
			Account account = new Account();
			account.setUsername(username);
			account.setPassword(SecurityUtils.Hash(password, salt));
			account.setPasswordSalt(salt);
			account.setMailbox(email);
			em.persist(account);

			// RegistrationManager.SendActivationMail("artstoremail", username,
			// RegistrationManager.GenerateActivationCode(account));

			em.getTransaction().commit();
			em.close();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			if(em != null)
			{
				em.close();
			}
			
			return false;
		}
		
		return true;

	}

	public boolean IsLogged(HttpSession session)
	{
		return session.getAttribute("sessionUID") != null && session.getAttribute("accountUID") != null;
	}

	public boolean ValidateSession(HttpSession session)
	{
		UUID sessionUID = (UUID) session.getAttribute("sessionUID");
		UUID accountUID = (UUID) session.getAttribute("accountUID");

		return sessionMap.containsKey(accountUID) && sessionMap.get(accountUID).equals(sessionUID);
	}

	public UUID BindSession(HttpSession session, UUID accountUID)
	{
		UUID sessionUID = UUID.randomUUID();

		sessionMap.put(accountUID, sessionUID);

		session.setAttribute("sessionUID", sessionUID);
		session.setAttribute("accountUID", accountUID);

		return sessionUID;
	}
}
