package com.artstore.mail;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.IMailManager;

@Component
public class MailManager extends AbstractManager implements IMailManager
{
	private Properties mailProps = new Properties();
	private String     login;
	private String     password;

	private boolean isEnabled;
	
	@Autowired
	public MailManager(Core core)
	{
		super(core);
	}

	@Override
	public boolean Initialize()
	{
		isEnabled = Boolean.parseBoolean(Core().GetProperty("mail.enabled"));		
		if(!isEnabled) { return true; }
	
		login = Core().GetProperty("mail.login");
		password = Core().GetProperty("mail.password");

		AbstractEnvironment env = (AbstractEnvironment) Core().GetEnvironment();

		for(Iterator<PropertySource<?>> it = env.getPropertySources().iterator();it.hasNext();)
		{
			PropertySource<?> ps = (PropertySource<?>) it.next();

			if (ps instanceof MapPropertySource)
			{
				Map<String, Object> map = ((MapPropertySource)ps).getSource();
				
				for(Entry<String, Object> en : map.entrySet())
				{
					if(en.getKey().startsWith("mail.smtp"))
					{
						mailProps.setProperty(en.getKey(), (String) en.getValue());
					}
				}
			}
		}

		return true;
	}

	protected Session CreateSession()
	{
		return Session.getInstance(mailProps, new Authenticator()
		{
			@Override
			protected PasswordAuthentication getPasswordAuthentication()
			{
				return new PasswordAuthentication(login, password);
			}
		});
	}

	public boolean SendMail(String from, String to, String subject, String msg)
	{
		if(!isEnabled) { return false; }
		
		Message message = new MimeMessage(CreateSession());

		try
		{
			message.setFrom(new InternetAddress(from));
			message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(to));
			message.setSubject(subject);

			MimeBodyPart mimeBodyPart = new MimeBodyPart();
			mimeBodyPart.setContent(msg, "text/html; charset=UTF-8");

			Multipart multipart = new MimeMultipart();
			multipart.addBodyPart(mimeBodyPart);

			message.setContent(multipart);

			Transport.send(message);
		}
		catch(MessagingException e)
		{
			Core().Error("Mail Manager", "Mail sending error", e.toString());

			return false;
		}

		return true;
	}
}
