package com.artstore.log;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import com.artstore.Core;
import com.artstore.managers.AbstractManager;
import com.artstore.managers.ILogManager;
import com.artstore.repositories.LogRepository;

@Component
public class LogManager extends AbstractManager implements ILogManager
{
	private LogRepository logRepo;
	
	@Autowired
	public LogManager(Core core, LogRepository logRepo)
	{
		super(core);
		
		this.logRepo = logRepo;
	}

	@Override
	public boolean Initialize()
	{
		return super.Initialize();
	}

	@Override
	public boolean Dispose()
	{
		return super.Dispose();
	}
	
	@Override
	public LogRepository GetRepo()
	{
		return logRepo;
	}
	
	public <TID> Page<LogEntry<TID>> Fetch(int pageNumber, int pageSize)
	{
		 Pageable pageableRequest = PageRequest.of(pageNumber, pageSize);
		 
	     Page<LogEntry<TID>> users = GetRepo().findAll(pageableRequest);

	     return users;
	}

	@Override
	public <TID> LogEntry<TID> Post(LogEntry<TID> newLogEntry)
	{
		return PushLogEntry(newLogEntry);
	}
	
	protected <TID> LogEntry<TID> PushLogEntry(LogEntry<TID> newLogEntry)
	{
		try
		{
			return logRepo.save(newLogEntry);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		
		return null;
	}
}
