package com.artstore.log;

import javax.persistence.AttributeConverter;

public enum LogLevel
{
	INFO(0, "Information", 0),
	WARN(1, "Warning", 1),
	ERROR(2, "Error", 2),
	UNKNOWN(-1, "Unknown", Integer.MAX_VALUE);

	int    ID;
	String name;
	int    priority;

	private LogLevel(int iD, String name, int priority)
	{
		ID = iD;
		this.name = name;
		this.priority = priority;
	}

	public int GetID()
	{
		return ID;
	}

	public String GetName()
	{
		return name;
	}

	public int GetPriority()
	{
		return priority;
	}

	public static class LogLevelConverter implements AttributeConverter<LogLevel, Integer>
	{
		@Override
		public Integer convertToDatabaseColumn(LogLevel attribute)
		{
			return attribute.GetID();
		}

		@Override
		public LogLevel convertToEntityAttribute(Integer dbData)
		{
			for (LogLevel logLevel : LogLevel.values())
			{
				if (logLevel.GetID() == dbData)
				{
					return logLevel;
				}
			}
			
			return LogLevel.UNKNOWN;
		}
	}
}
