package com.artstore.log;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import org.hibernate.annotations.CreationTimestamp;

import com.artstore.entity.IEntity;

@Entity
public class LogEntry<TID> implements IEntity<Long>
{
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	private Long id;
	
	@Column(nullable = false)
	@CreationTimestamp
	private Date occurrenceDate;
	
	@Column(nullable = true)
	@Embedded
	private Causer causer;
	
	@Column(nullable = false)
	private LogLevel logLevel;
	
	private String title;
	private String description;
	
	public LogEntry(LogLevel logLevel, Causer causer, String title, String description)
	{
		this.causer = causer;
		
		this.logLevel = logLevel;
		this.title = title;
		this.description = description;
	}
	
	public LogEntry()
	{
		
	}
	
	public static <TID> LogEntry<TID> Create(LogLevel logLevel, IEntity<TID> causer, String title, String description)
	{
		return new LogEntry<TID>(logLevel, Causer.Create(causer), title, description);
	}
	
	public static LogEntry<Void> Create(LogLevel logLevel, String causer,  String title, String description)
	{
		return new LogEntry<Void>(logLevel, Causer.Create(causer), title, description);
	}
	
	@Override
	public Long GetID()
	{
		return id;
	}
	
	public Long getId()
	{
		return id;
	}

	public Date getOccurrenceDate()
	{
		return occurrenceDate;
	}

	public void setOccurrenceDate(Date occurrenceDate)
	{
		this.occurrenceDate = occurrenceDate;
	}
	
	public Causer getCauser()
	{
		return causer;
	}

	public void setCauser(Causer causer)
	{
		this.causer = causer;
	}

	public LogLevel getLogLevel()
	{
		return logLevel;
	}

	public void setLogLevel(LogLevel logLevel)
	{
		this.logLevel = logLevel;
	}

	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	public String getDescription()
	{
		return description;
	}

	public void setDescription(String description)
	{
		this.description = description;
	}
}
