package com.artstore.log;

import java.io.Serializable;

import javax.persistence.Embeddable;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

import com.artstore.Core;
import com.artstore.entity.IEntity;

@Embeddable
public class Causer implements Serializable
{	
	private static final long serialVersionUID = -7329244251594321162L;
	
	private Serializable causerID;
	private String causerName;
	
	public Causer() {}
	
	public Causer(Serializable causerID,  String causerName)
	{
		this.causerID = causerID;
		this.causerName = causerName;
	}
	
	public static <TID> Causer Create(IEntity<TID> entity)
	{
		return entity == null ? new Causer(null, "NULL") : new Causer((Serializable)entity.GetID(), entity.getClass().getCanonicalName());
	}
	
	public static Causer Create(String name)
	{
		return new Causer(null, name);
	}

	public Serializable getCauserID()
	{
		return causerID;
	}

	public void setCauserID(Serializable causerID)
	{
		this.causerID = causerID;
	}

	public String getCauserName()
	{
		return causerName;
	}

	public void setCauserName(String causerName)
	{
		this.causerName = causerName;
	}
	
	public IEntity<?> Get(Core core)
	{
		EntityManager em = core.CreateEntityManager();
		
		try
		{
			EntityTransaction t = em.getTransaction();
			t.begin();
			
			return (IEntity<?>) em.find(Class.forName(causerName), causerID);
		}
		catch(Exception ex)
		{
			
		}
		
		return null;
	}
}
